<?php

	if (!defined('IN_HUGLO')) {
		exit;
	}

	class template_compile {
		var $template;
	
		var $block_names = array();
		var $block_else_level = array();
	
		function template_compile(&$template)
		{
			$this->template = &$template;
		}
	
		function _tpl_load_file($handle, $store_in_db = false)
		{
			if (!file_exists($this->template->files[$handle]))
			{
				trigger_error("template->_tpl_load_file(): File {$this->template->files[$handle]} does not exist or is empty", E_USER_ERROR);
			}
	
			$this->template->compiled_code[$handle] = $this->compile(trim(@file_get_contents($this->template->files[$handle])));
	
			$this->compile_write($handle, $this->template->compiled_code[$handle]);
		}
	
		function remove_php_tags(&$code)
		{
			$match = array(
				'#<([\?%])=?.*?\1>#s',
				'#<script\s+language\s*=\s*(["\']?)php\1\s*>.*?</script\s*>#s',
				'#<\?php(?:\r\n?|[ \n\t]).*?\?>#s'
			);
	
			$code = preg_replace($match, '', $code);
		}
	
		function compile($code, $no_echo = false, $echo_var = '')
		{
			if ($echo_var)
			{
				global $$echo_var;
			}
	
			$this->remove_php_tags($code);
	
			preg_match_all('#<!-- PHP -->(.*?)<!-- ENDPHP -->#s', $code, $matches);
			$php_blocks = $matches[1];
			$code = preg_replace('#<!-- PHP -->.*?<!-- ENDPHP -->#s', '<!-- PHP -->', $code);
	
			preg_match_all('#<!-- INCLUDE ([a-zA-Z0-9\_\-\+\./]+) -->#', $code, $matches);
			$include_blocks = $matches[1];
			$code = preg_replace('#<!-- INCLUDE [a-zA-Z0-9\_\-\+\./]+ -->#', '<!-- INCLUDE -->', $code);
	
			preg_match_all('#<!-- INCLUDEPHP ([a-zA-Z0-9\_\-\+\./]+) -->#', $code, $matches);
			$includephp_blocks = $matches[1];
			$code = preg_replace('#<!-- INCLUDEPHP [a-zA-Z0-9\_\-\+\./]+ -->#', '<!-- INCLUDEPHP -->', $code);
	
			preg_match_all('#<!-- ([^<].*?) (.*?)? ?-->#', $code, $blocks, PREG_SET_ORDER);
	
			$text_blocks = preg_split('#<!-- [^<].*? (?:.*?)? ?-->#', $code);
	
			for ($i = 0, $j = sizeof($text_blocks); $i < $j; $i++)
			{
				$this->compile_var_tags($text_blocks[$i]);
			}
			$compile_blocks = array();
	
			for ($curr_tb = 0, $tb_size = sizeof($blocks); $curr_tb < $tb_size; $curr_tb++)
			{
				$block_val = &$blocks[$curr_tb];
	
				switch ($block_val[1])
				{
					case 'BEGIN':
						$this->block_else_level[] = false;
						$compile_blocks[] = '<?php ' . $this->compile_tag_block($block_val[2]) . ' ?>';
					break;
	
					case 'BEGINELSE':
						$this->block_else_level[sizeof($this->block_else_level) - 1] = true;
						$compile_blocks[] = '<?php }} else { ?>';
					break;
	
					case 'END':
						array_pop($this->block_names);
						$compile_blocks[] = '<?php ' . ((array_pop($this->block_else_level)) ? '}' : '}}') . ' ?>';
					break;
	
					case 'IF':
						$compile_blocks[] = '<?php ' . $this->compile_tag_if($block_val[2], false) . ' ?>';
					break;
	
					case 'ELSE':
						$compile_blocks[] = '<?php } else { ?>';
					break;
	
					case 'ELSEIF':
						$compile_blocks[] = '<?php ' . $this->compile_tag_if($block_val[2], true) . ' ?>';
					break;
	
					case 'ENDIF':
						$compile_blocks[] = '<?php } ?>';
					break;
	
					case 'DEFINE':
						$compile_blocks[] = '<?php ' . $this->compile_tag_define($block_val[2], true) . ' ?>';
					break;
	
					case 'UNDEFINE':
						$compile_blocks[] = '<?php ' . $this->compile_tag_define($block_val[2], false) . ' ?>';
					break;
	
					case 'INCLUDE':
						$temp = array_shift($include_blocks);
						$compile_blocks[] = '<?php ' . $this->compile_tag_include($temp) . ' ?>';
						$this->template->_tpl_include($temp, false);
					break;
	
					case 'INCLUDEPHP':
						$compile_blocks[] =  '<?php ' . $this->compile_tag_include_php(array_shift($includephp_blocks)) . ' ?>';
					break;
	
					case 'PHP':
						$compile_blocks[] = '<?php ' . array_shift($php_blocks) . ' ?>';
					break;
	
					default:
						$this->compile_var_tags($block_val[0]);
						$trim_check = trim($block_val[0]);
						$compile_blocks[] = (!$no_echo) ? ((!empty($trim_check)) ? $block_val[0] : '') : ((!empty($trim_check)) ? $block_val[0] : '');
					break;
				}
			}
	
			$template_php = '';
			for ($i = 0, $size = sizeof($text_blocks); $i < $size; $i++)
			{
				$trim_check_text = trim($text_blocks[$i]);
				$template_php .= (!$no_echo) ? (($trim_check_text != '') ? $text_blocks[$i] : '') . ((isset($compile_blocks[$i])) ? $compile_blocks[$i] : '') : (($trim_check_text != '') ? $text_blocks[$i] : '') . ((isset($compile_blocks[$i])) ? $compile_blocks[$i] : '');
			}
	
			$template_php = str_replace(' ?><?php ', ' ', $template_php);
	
			return (!$no_echo) ? $template_php : "\$$echo_var .= '" . $template_php . "'";
		}
	
		function compile_var_tags(&$text_blocks)
		{
			$varrefs = array();
	
			preg_match_all('#\{((?:[a-z0-9\-_]+\.)+)(\$)?([A-Z0-9\-_]+)\}#', $text_blocks, $varrefs, PREG_SET_ORDER);
	
			foreach ($varrefs as $var_val)
			{
				$namespace = $var_val[1];
				$varname = $var_val[3];
				$new = $this->generate_block_varref($namespace, $varname, true, $var_val[2]);
	
				$text_blocks = str_replace($var_val[0], $new, $text_blocks);
			}
	
			if (strpos($text_blocks, '{L_') !== false)
			{
				$text_blocks = preg_replace('#\{L_([a-z0-9\-_]*)\}#is', "<?php echo ((isset(\$this->_rootref['L_\\1'])) ? \$this->_rootref['L_\\1'] : ((isset(\$user->lang['\\1'])) ? \$user->lang['\\1'] : '{ \\1 }')); ?>", $text_blocks);
			}
	
			if (strpos($text_blocks, '{LA_') !== false)
			{
				$text_blocks = preg_replace('#\{LA_([a-z0-9\-_]*)\}#is', "<?php echo ((isset(\$this->_rootref['LA_\\1'])) ? \$this->_rootref['LA_\\1'] : ((isset(\$this->_rootref['L_\\1'])) ? addslashes(\$this->_rootref['L_\\1']) : ((isset(\$user->lang['\\1'])) ? addslashes(\$user->lang['\\1']) : '{ \\1 }'))); ?>", $text_blocks);
			}
	
			$text_blocks = preg_replace('#\{([a-z0-9\-_]+)\}#is', "<?php echo (isset(\$this->_rootref['\\1'])) ? \$this->_rootref['\\1'] : ''; ?>", $text_blocks);
			$text_blocks = preg_replace('#\{\$([a-z0-9\-_]+)\}#is', "<?php echo (isset(\$this->_tpldata['DEFINE']['.']['\\1'])) ? \$this->_tpldata['DEFINE']['.']['\\1'] : ''; ?>", $text_blocks);
	
			return;
		}
	
		function compile_tag_block($tag_args)
		{
			$no_nesting = false;
	
			if (strpos($tag_args, '!') === 0)
			{
				$no_nesting = substr_count($tag_args, '!');
				$tag_args = substr($tag_args, $no_nesting);
			}
	
			if (preg_match('#^([^()]*)\(([\-\d]+)(?:,([\-\d]+))?\)$#', $tag_args, $match))
			{
				$tag_args = $match[1];
	
				if ($match[2] < 0)
				{
					$loop_start = '($_' . $tag_args . '_count ' . $match[2] . ' < 0 ? 0 : $_' . $tag_args . '_count ' . $match[2] . ')';
				}
				else
				{
					$loop_start = '($_' . $tag_args . '_count < ' . $match[2] . ' ? $_' . $tag_args . '_count : ' . $match[2] . ')';
				}
	
				if (strlen($match[3]) < 1 || $match[3] == -1)
				{
					$loop_end = '$_' . $tag_args . '_count';
				}
				else if ($match[3] >= 0)
				{
					$loop_end = '(' . ($match[3] + 1) . ' > $_' . $tag_args . '_count ? $_' . $tag_args . '_count : ' . ($match[3] + 1) . ')';
				}
				else //if ($match[3] < -1)
				{
					$loop_end = '$_' . $tag_args . '_count' . ($match[3] + 1);
				}
			}
			else
			{
				$loop_start = 0;
				$loop_end = '$_' . $tag_args . '_count';
			}
	
			$tag_template_php = '';
			array_push($this->block_names, $tag_args);
	
			if ($no_nesting !== false)
			{
				$block = array_slice($this->block_names, -$no_nesting);
			}
			else
			{
				$block = $this->block_names;
			}
	
			if (sizeof($block) < 2)
			{
				$tag_template_php = '$_' . $tag_args . "_count = (isset(\$this->_tpldata['$tag_args'])) ? sizeof(\$this->_tpldata['$tag_args']) : 0;";
				$varref = "\$this->_tpldata['$tag_args']";
			}
			else
			{
				$namespace = implode('.', $block);
	
				$varref = $this->generate_block_data_ref($namespace, false);
	
				$tag_template_php = '$_' . $tag_args . '_count = (isset(' . $varref . ')) ? sizeof(' . $varref . ') : 0;';
			}
	
			$tag_template_php .= 'if ($_' . $tag_args . '_count) {';
	
			$tag_template_php .= 'for ($_' . $tag_args . '_i = ' . $loop_start . '; $_' . $tag_args . '_i < ' . $loop_end . '; ++$_' . $tag_args . '_i){';
			$tag_template_php .= '$_'. $tag_args . '_val = &' . $varref . '[$_'. $tag_args. '_i];';
	
			return $tag_template_php;
		}
	
		function compile_tag_if($tag_args, $elseif)
		{
			// Tokenize args for 'if' tag.
			preg_match_all('/(?:
				"[^"\\\\]*(?:\\\\.[^"\\\\]*)*"         |
				\'[^\'\\\\]*(?:\\\\.[^\'\\\\]*)*\'     |
				[(),]                                  |
				[^\s(),]+)/x', $tag_args, $match);
	
			$tokens = $match[0];
			$is_arg_stack = array();
	
			for ($i = 0, $size = sizeof($tokens); $i < $size; $i++)
			{
				$token = &$tokens[$i];
	
				switch ($token)
				{
					case '!==':
					case '===':
					case '<<':
					case '>>':
					case '|':
					case '^':
					case '&':
					case '~':
					case ')':
					case ',':
					case '+':
					case '-':
					case '*':
					case '/':
					case '@':
					break;
	
					case '==':
					case 'eq':
						$token = '==';
					break;
	
					case '!=':
					case '<>':
					case 'ne':
					case 'neq':
						$token = '!=';
					break;
	
					case '<':
					case 'lt':
						$token = '<';
					break;
	
					case '<=':
					case 'le':
					case 'lte':
						$token = '<=';
					break;
	
					case '>':
					case 'gt':
						$token = '>';
					break;
	
					case '>=':
					case 'ge':
					case 'gte':
						$token = '>=';
					break;
	
					case '&&':
					case 'and':
						$token = '&&';
					break;
	
					case '||':
					case 'or':
						$token = '||';
					break;
	
					case '!':
					case 'not':
						$token = '!';
					break;
	
					case '%':
					case 'mod':
						$token = '%';
					break;
	
					case '(':
						array_push($is_arg_stack, $i);
					break;
	
					case 'is':
						$is_arg_start = ($tokens[$i-1] == ')') ? array_pop($is_arg_stack) : $i-1;
						$is_arg	= implode('	', array_slice($tokens,	$is_arg_start, $i -	$is_arg_start));
	
						$new_tokens	= $this->_parse_is_expr($is_arg, array_slice($tokens, $i+1));
	
						array_splice($tokens, $is_arg_start, sizeof($tokens), $new_tokens);
	
						$i = $is_arg_start;
	
					default:
						if (preg_match('#^((?:[a-z0-9\-_]+\.)+)?(\$)?(?=[A-Z])([A-Z0-9\-_]+)#s', $token, $varrefs))
						{
							$token = (!empty($varrefs[1])) ? $this->generate_block_data_ref(substr($varrefs[1], 0, -1), true, $varrefs[2]) . '[\'' . $varrefs[3] . '\']' : (($varrefs[2]) ? '$this->_tpldata[\'DEFINE\'][\'.\'][\'' . $varrefs[3] . '\']' : '$this->_rootref[\'' . $varrefs[3] . '\']');
						}
						else if (preg_match('#^\.((?:[a-z0-9\-_]+\.?)+)$#s', $token, $varrefs))
						{
							$blocks = explode('.', $varrefs[1]);
	
							if (sizeof($blocks) > 1)
							{
								$block = array_pop($blocks);
								$namespace = implode('.', $blocks);
								$varref = $this->generate_block_data_ref($namespace, true);
	
								$varref .= "['" . $block . "']";
							}
							else
							{
								$varref = '$this->_tpldata';
	
								$varref .= "['" . $blocks[0] . "']";
							}
							$token = "sizeof($varref)";
						}
						else if (!empty($token))
						{
							$token = '(' . $token . ')';
						}
	
					break;
				}
			}
	
			if (!sizeof($tokens) || str_replace(array(' ', '=', '!', '<', '>', '&', '|', '%', '(', ')'), '', implode('', $tokens)) == '')
			{
				$tokens = array('false');
			}
			return (($elseif) ? '} else if (' : 'if (') . (implode(' ', $tokens) . ') { ');
		}
	
		function compile_tag_define($tag_args, $op)
		{
			preg_match('#^((?:[a-z0-9\-_]+\.)+)?\$(?=[A-Z])([A-Z0-9_\-]*)(?: = (\'?)([^\']*)(\'?))?$#', $tag_args, $match);
	
			if (empty($match[2]) || (!isset($match[4]) && $op))
			{
				return '';
			}
	
			if (!$op)
			{
				return 'unset(' . (($match[1]) ? $this->generate_block_data_ref(substr($match[1], 0, -1), true, true) . '[\'' . $match[2] . '\']' : '$this->_tpldata[\'DEFINE\'][\'.\'][\'' . $match[2] . '\']') . ');';
			}
	
			if ($match[3] && $match[5])
			{
				$match[4] = str_replace(array('\\\'', '\\\\', '\''), array('\'', '\\', '\\\''), $match[4]);
	
				$match[4] = $this->compile($match[4]);
	
				$match[4] = "'" . str_replace(array('<?php echo ', '; ?>'), array("' . ", " . '"), $match[4]) . "'";
			}
			else
			{
				preg_match('#true|false|\.#i', $match[4], $type);
	
				switch (strtolower($type[0]))
				{
					case 'true':
					case 'false':
						$match[4] = strtoupper($match[4]);
					break;
	
					case '.':
						$match[4] = doubleval($match[4]);
					break;
	
					default:
						$match[4] = intval($match[4]);
					break;
				}
			}
	
			return (($match[1]) ? $this->generate_block_data_ref(substr($match[1], 0, -1), true, true) . '[\'' . $match[2] . '\']' : '$this->_tpldata[\'DEFINE\'][\'.\'][\'' . $match[2] . '\']') . ' = ' . $match[4] . ';';
		}
	
		function compile_tag_include($tag_args)
		{
			return "\$this->_tpl_include('$tag_args');";
		}
	
		function compile_tag_include_php($tag_args)
		{
			return "include('" . $tag_args . "');";
		}
	
		function _parse_is_expr($is_arg, $tokens)
		{
			$expr_end = 0;
			$negate_expr = false;
	
			if (($first_token = array_shift($tokens)) == 'not')
			{
				$negate_expr = true;
				$expr_type = array_shift($tokens);
			}
			else
			{
				$expr_type = $first_token;
			}
	
			switch ($expr_type)
			{
				case 'even':
					if (@$tokens[$expr_end] == 'by')
					{
						$expr_end++;
						$expr_arg = $tokens[$expr_end++];
						$expr = "!(($is_arg / $expr_arg) % $expr_arg)";
					}
					else
					{
						$expr = "!($is_arg & 1)";
					}
				break;
	
				case 'odd':
					if (@$tokens[$expr_end] == 'by')
					{
						$expr_end++;
						$expr_arg = $tokens[$expr_end++];
						$expr = "(($is_arg / $expr_arg) % $expr_arg)";
					}
					else
					{
						$expr = "($is_arg & 1)";
					}
				break;
	
				case 'div':
					if (@$tokens[$expr_end] == 'by')
					{
						$expr_end++;
						$expr_arg = $tokens[$expr_end++];
						$expr = "!($is_arg % $expr_arg)";
					}
				break;
			}
	
			if ($negate_expr)
			{
				$expr = "!($expr)";
			}
	
			array_splice($tokens, 0, $expr_end, $expr);
	
			return $tokens;
		}
	
		function generate_block_varref($namespace, $varname, $echo = true, $defop = false)
		{
			$namespace = substr($namespace, 0, -1);
	
			$varref = $this->generate_block_data_ref($namespace, true, $defop);
	
			$varref .= "['$varname']";
			$varref = ($echo) ? "<?php echo $varref; ?>" : ((isset($varref)) ? $varref : '');
	
			return $varref;
		}
	
		function generate_block_data_ref($blockname, $include_last_iterator, $defop = false)
		{
			$blocks = explode('.', $blockname);
			$blockcount = sizeof($blocks) - 1;
	
			if ($defop)
			{
				$varref = '$this->_tpldata[\'DEFINE\']';
				for ($i = 0; $i < $blockcount; $i++)
				{
					$varref .= "['" . $blocks[$i] . "'][\$_" . $blocks[$i] . '_i]';
				}
				$varref .= "['" . $blocks[$blockcount] . "']";
				if ($include_last_iterator)
				{
					$varref .= '[$_' . $blocks[$blockcount] . '_i]';
				}
				return $varref;
			}
			else if ($include_last_iterator)
			{
				return '$_'. $blocks[$blockcount] . '_val';
			}
			else
			{
				return '$_'. $blocks[$blockcount - 1] . '_val[\''. $blocks[$blockcount]. '\']';
			}
		}
	
		function compile_write($handle, $data)
		{
			global $phpEx;
	
			$filename = $this->template->cachepath . str_replace('/', '.', $this->template->filename[$handle]) . '.' . $phpEx;
	
			if ($fp = @fopen($filename, 'wb'))
			{
				@flock($fp, LOCK_EX);
				@fwrite ($fp, $data);
				@flock($fp, LOCK_UN);
				@fclose($fp);
			}
	
			return;
		}
	}
	
?>