<?php

	if (!defined('IN_HUGLO')) {
		exit;
	}
	
	class template {
		var $_tpldata = array('.' => array(0 => array()));
		var $_rootref;
	
		var $root = '';
		var $cachepath = '';
		var $files = array();
		var $filename = array();
	
		var $compiled_code = array();
	
		function set_filenames($filename_array)
		{
			if (!is_array($filename_array))
			{
				return false;
			}
			foreach ($filename_array as $handle => $filename)
			{
				if (empty($filename))
				{
					trigger_error("template->set_filenames: Empty filename specified for $handle", E_USER_ERROR);
				}
	
				$this->filename[$handle] = $filename;
				$this->files[$handle] = $this->root . '/' . $filename;
			}
			
			return true;
		}
	
		function destroy()
		{
			$this->_tpldata = array('.' => array(0 => array()));
		}
	
		function destroy_block_vars($blockname)
		{
			if (strpos($blockname, '.') !== false)
			{
				$blocks = explode('.', $blockname);
				$blockcount = sizeof($blocks) - 1;
	
				$str = &$this->_tpldata;
				for ($i = 0; $i < $blockcount; $i++)
				{
					$str = &$str[$blocks[$i]];
					$str = &$str[sizeof($str) - 1];
				}
	
				unset($str[$blocks[$blockcount]]);
			}
			else
			{
				unset($this->_tpldata[$blockname]);
			}
	
			return true;
		}
	
		function display($handle, $include_once = true)
		{
	
			if ($filename = $this->_tpl_load($handle))
			{
				($include_once) ? include_once($filename) : include($filename);
			}
			else
			{
				eval(' ?>' . $this->compiled_code[$handle] . '<?php ');
			}
	
			return true;
		}
	
		function assign_display($handle, $template_var = '', $return_content = true, $include_once = false)
		{
			ob_start();
			$this->display($handle, $include_once);
			$contents = ob_get_clean();
	
			if ($return_content)
			{
				return $contents;
			}
	
			$this->assign_var($template_var, $contents);
	
			return true;
		}
		
		function _tpl_load(&$handle)
		{
			global $phpEx;
	
			$filename = $this->cachepath . str_replace('/', '.', $this->filename[$handle]) . '.' . $phpEx;
			
			$recompile = false;
			if (!file_exists($filename) || @filesize($filename) === 0)
			{
				$recompile = true;
			}
			
			if (!$recompile)
			{
				return $filename;
			}
			
			$compile = new template_compile($this);
	
			if (!isset($this->files[$handle]))
			{
				trigger_error("template->_tpl_load(): No file specified for handle $handle", E_USER_ERROR);
			}
	
			$compile->_tpl_load_file($handle);
			return false;
		}
	
		function assign_vars($vararray)
		{
			foreach ($vararray as $key => $val)
			{
				$this->_rootref[$key] = $val;
			}
	
			return true;
		}
	
		function assign_var($varname, $varval)
		{
			$this->_rootref[$varname] = $varval;
	
			return true;
		}
	
		function assign_block_vars($blockname, $vararray)
		{
			if (strpos($blockname, '.') !== false)
			{
				$blocks = explode('.', $blockname);
				$blockcount = sizeof($blocks) - 1;
	
				$str = &$this->_tpldata;
				for ($i = 0; $i < $blockcount; $i++)
				{
					$str = &$str[$blocks[$i]];
					$str = &$str[sizeof($str) - 1];
				}
	
				$s_row_count = isset($str[$blocks[$blockcount]]) ? sizeof($str[$blocks[$blockcount]]) : 0;
				$vararray['S_ROW_COUNT'] = $s_row_count;
	
				if (!$s_row_count)
				{
					$vararray['S_FIRST_ROW'] = true;
				}
	
				$vararray['S_LAST_ROW'] = true;
				if ($s_row_count > 0)
				{
					unset($str[$blocks[$blockcount]][($s_row_count - 1)]['S_LAST_ROW']);
				}
	
				$str[$blocks[$blockcount]][] = $vararray;
			}
			else
			{
				$s_row_count = (isset($this->_tpldata[$blockname])) ? sizeof($this->_tpldata[$blockname]) : 0;
				$vararray['S_ROW_COUNT'] = $s_row_count;
	
				if (!$s_row_count)
				{
					$vararray['S_FIRST_ROW'] = true;
				}
	
				$vararray['S_LAST_ROW'] = true;
				if ($s_row_count > 0)
				{
					unset($this->_tpldata[$blockname][($s_row_count - 1)]['S_LAST_ROW']);
				}
	
				$this->_tpldata[$blockname][] = $vararray;
			}
	
			return true;
		}
	
		function alter_block_array($blockname, $vararray, $key = false, $mode = 'insert')
		{
			if (strpos($blockname, '.') !== false)
			{
				return false;
			}
			
			if ($key === false || $key === true)
			{
				$key = ($key === false) ? 0 : sizeof($this->_tpldata[$blockname]);
			}
	
			if (is_array($key))
			{
				list($search_key, $search_value) = @each($key);
	
				$key = NULL;
				foreach ($this->_tpldata[$blockname] as $i => $val_ary)
				{
					if ($val_ary[$search_key] === $search_value)
					{
						$key = $i;
						break;
					}
				}
	
				if ($key === NULL)
				{
					return false;
				}
			}
	
			if ($mode == 'insert')
			{
				if ($key >= sizeof($this->_tpldata[$blockname]))
				{
					$key = sizeof($this->_tpldata[$blockname]);
					unset($this->_tpldata[$blockname][($key - 1)]['S_LAST_ROW']);
					$vararray['S_LAST_ROW'] = true;
				}
				else if ($key === 0)
				{
					unset($this->_tpldata[$blockname][0]['S_FIRST_ROW']);
					$vararray['S_FIRST_ROW'] = true;
				}
	
				for ($i = sizeof($this->_tpldata[$blockname]); $i > $key; $i--)
				{
					$this->_tpldata[$blockname][$i] = $this->_tpldata[$blockname][$i-1];
					$this->_tpldata[$blockname][$i]['S_ROW_COUNT'] = $i;
				}
	
				$vararray['S_ROW_COUNT'] = $key;
				$this->_tpldata[$blockname][$key] = $vararray;
	
				return true;
			}
	
			if ($mode == 'change')
			{
				if ($key == sizeof($this->_tpldata[$blockname]))
				{
					$key--;
				}
	
				$this->_tpldata[$blockname][$key] = array_merge($this->_tpldata[$blockname][$key], $vararray);
				return true;
			}
	
			return false;
		}
	
		function _tpl_include($filename, $include = true)
		{
			$handle = $filename;
			$this->filename[$handle] = $filename;
			$this->files[$handle] = $this->root . '/' . $filename;
	
			$filename = $this->_tpl_load($handle);
	
			if ($include)
			{
				if ($filename)
				{
					include($filename);
					return;
				}
				eval(' ?>' . $this->compiled_code[$handle] . '<?php ');
			}
		}
	}

?>